#include <SPI.h>
#include "printf.h"
#include "RF24.h"

RF24 radio(9, 10); // using pin 9 for the CE pin, and pin 10 for the CSN pin

// For this example, we'll be using 6 addresses; 1 for each TX node
// It is very helpful to think of an address as a path instead of as
// an identifying device destination
// Notice that the last byte is the only byte that changes in the last 5
// addresses. This is a limitation of the nRF24L01 transceiver for pipes 2-5
// because they use the same first 4 bytes from pipe 1.
uint64_t address[6] = {0x7878787878LL,
                       0xB3B4B5B6F1LL,
                       0xB3B4B5B6CDLL,
                       0xB3B4B5B6A3LL,
                       0xB3B4B5B60FLL,
                       0xB3B4B5B605LL
                      };

#define SIZE 32

// Teksten als laatste
// Hiervoor mag je long, bool,  int gebruiken
struct DataObject
{
  unsigned long nodeID;
  unsigned long ObjectID;
  bool jaNee;
  int nummer;
  long normalLong;
  char textBuffer[SIZE + 1]; // Teksten moeten als laatste
};

DataObject payload;

// This example uses all 6 pipes to receive while TX nodes only use 2 pipes
// To make this easier we'll use a function to manage the addresses, and the
// payload's nodeID
void setSendAdress(); // declare a prototype; definition is found after the loop()

void setup() {

  Serial.begin(9600);
  while (!Serial) {
    // some boards need to wait to ensure access to serial over USB
  }

  // initialize the transceiver on the SPI bus
  if (!radio.begin()) {
    Serial.println(F("radio hardware is not responding!!"));
    while (1) {} // hold in infinite loop
  }

  // print example's introductory prompt
  Serial.println(F("RF24/examples/MulticeiverDemo"));
  Serial.println(F("    the identifying node number that transmits."));

  // Set the PA Level low to try preventing power supply related problems
  // because these examples are likely run with nodes in close proximity of
  // each other.
  radio.setPALevel(RF24_PA_LOW); // RF24_PA_MAX is default.

  // save on transmission time by setting the radio to only transmit the
  // number of bytes we need to transmit a float
  radio.setPayloadSize(sizeof(payload)); // 2x int datatype occupy 8 bytes

  // Set the pipe addresses accordingly. This function additionally also
  // calls startListening() or stopListening() and sets the payload's nodeID
  setSendAdress();

  // For debugging info
  // printf_begin();             // needed only once for printing details
  // radio.printDetails();       // (smaller) function that prints raw register values
  // radio.printPrettyDetails(); // (larger) function that prints human readable data
}

void loop() {
  uint8_t pipe;
  if (radio.available(&pipe)) {             // is there a payload? get the pipe number that recieved it
    uint8_t bytes = radio.getPayloadSize(); // get the size of the payload
    radio.read(&payload, bytes);            // fetch payload from FIFO
    Serial.print(F("Received "));
    Serial.print(bytes);                    // print the size of the payload
    Serial.print(F(" bytes on pipe "));
    Serial.print(pipe);                     // print the pipe number
    Serial.print(F(" from node "));
    Serial.print(payload.nodeID);           // print the payload's origin
    Serial.print(F(". ObjectID: "));
    Serial.print(payload.ObjectID);      // print the payload's number
    Serial.print(F(" text: "));
    String txt = payload.textBuffer;
    Serial.print(txt);
    Serial.print(F(" Ja/Nee: "));
    Serial.print(payload.jaNee == 0 ? "false" : "true");
    Serial.print(F(" Nummer: "));
    Serial.print(payload.nummer);
    Serial.print(F(" Normal long: "));
    Serial.print(payload.normalLong);
    Serial.println();
  }
}

void setSendAdress() {
  // Set the addresses for all pipes to TX nodes
  for (uint8_t i = 0; i < 6; ++i)
  {
    radio.openReadingPipe(i, address[i]);
  }

  radio.startListening(); // put radio in RX mode
}
